package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{ARN, TableName, KeyspaceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTableAutoScalingSettingsResponse(
    keyspaceName: KeyspaceName,
    tableName: TableName,
    resourceArn: ARN,
    autoScalingSpecification: Optional[
      zio.aws.keyspaces.model.AutoScalingSpecification
    ] = Optional.Absent,
    replicaSpecifications: Optional[
      Iterable[zio.aws.keyspaces.model.ReplicaAutoScalingSpecification]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsResponse = {
    import GetTableAutoScalingSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsResponse
      .builder()
      .keyspaceName(KeyspaceName.unwrap(keyspaceName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        autoScalingSpecification.map(value => value.buildAwsValue())
      )(_.autoScalingSpecification)
      .optionallyWith(
        replicaSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse.ReadOnly =
    zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse
      .wrap(buildAwsValue())
}
object GetTableAutoScalingSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse =
      zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse(
        keyspaceName,
        tableName,
        resourceArn,
        autoScalingSpecification.map(value => value.asEditable),
        replicaSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyspaceName: KeyspaceName
    def tableName: TableName
    def resourceArn: ARN
    def autoScalingSpecification
        : Optional[zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly]
    def replicaSpecifications: Optional[
      List[zio.aws.keyspaces.model.ReplicaAutoScalingSpecification.ReadOnly]
    ]
    def getKeyspaceName: ZIO[Any, Nothing, KeyspaceName] =
      ZIO.succeed(keyspaceName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getAutoScalingSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoScalingSpecification",
      autoScalingSpecification
    )
    def getReplicaSpecifications: ZIO[Any, AwsError, List[
      zio.aws.keyspaces.model.ReplicaAutoScalingSpecification.ReadOnly
    ]] =
      AwsError.unwrapOptionField("replicaSpecifications", replicaSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsResponse
  ) extends zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse.ReadOnly {
    override val keyspaceName: KeyspaceName =
      zio.aws.keyspaces.model.primitives.KeyspaceName(impl.keyspaceName())
    override val tableName: TableName =
      zio.aws.keyspaces.model.primitives.TableName(impl.tableName())
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
    override val autoScalingSpecification
        : Optional[zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingSpecification())
        .map(value =>
          zio.aws.keyspaces.model.AutoScalingSpecification.wrap(value)
        )
    override val replicaSpecifications: Optional[
      List[zio.aws.keyspaces.model.ReplicaAutoScalingSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.keyspaces.model.ReplicaAutoScalingSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.GetTableAutoScalingSettingsResponse
  ): zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
