package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKeyspacesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    keyspaces: Iterable[zio.aws.keyspaces.model.KeyspaceSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse = {
    import ListKeyspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .keyspaces(keyspaces.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly =
    zio.aws.keyspaces.model.ListKeyspacesResponse.wrap(buildAwsValue())
}
object ListKeyspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ListKeyspacesResponse =
      zio.aws.keyspaces.model.ListKeyspacesResponse(
        nextToken.map(value => value),
        keyspaces.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def keyspaces: List[zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getKeyspaces: ZIO[Any, Nothing, List[
      zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly
    ]] = ZIO.succeed(keyspaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse
  ) extends zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.keyspaces.model.primitives.NextToken(value))
    override val keyspaces
        : List[zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly] = impl
      .keyspaces()
      .asScala
      .map { item =>
        zio.aws.keyspaces.model.KeyspaceSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse
  ): zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly = new Wrapper(impl)
}
