package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.Region
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaAutoScalingSpecification(
    region: Optional[Region] = Optional.Absent,
    autoScalingSpecification: Optional[
      zio.aws.keyspaces.model.AutoScalingSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification = {
    import ReplicaAutoScalingSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification
      .builder()
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        autoScalingSpecification.map(value => value.buildAwsValue())
      )(_.autoScalingSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.keyspaces.model.ReplicaAutoScalingSpecification.ReadOnly =
    zio.aws.keyspaces.model.ReplicaAutoScalingSpecification
      .wrap(buildAwsValue())
}
object ReplicaAutoScalingSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ReplicaAutoScalingSpecification =
      zio.aws.keyspaces.model.ReplicaAutoScalingSpecification(
        region.map(value => value),
        autoScalingSpecification.map(value => value.asEditable)
      )
    def region: Optional[Region]
    def autoScalingSpecification
        : Optional[zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly]
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getAutoScalingSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoScalingSpecification",
      autoScalingSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification
  ) extends zio.aws.keyspaces.model.ReplicaAutoScalingSpecification.ReadOnly {
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.keyspaces.model.primitives.Region(value))
    override val autoScalingSpecification
        : Optional[zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingSpecification())
        .map(value =>
          zio.aws.keyspaces.model.AutoScalingSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification
  ): zio.aws.keyspaces.model.ReplicaAutoScalingSpecification.ReadOnly =
    new Wrapper(impl)
}
