package zio.aws.keyspaces.model
import scala.jdk.CollectionConverters._
sealed trait Rs {
  def unwrap: software.amazon.awssdk.services.keyspaces.model.Rs
}
object Rs {
  def wrap(
      value: software.amazon.awssdk.services.keyspaces.model.Rs
  ): zio.aws.keyspaces.model.Rs = value match {
    case software.amazon.awssdk.services.keyspaces.model.Rs.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.keyspaces.model.Rs.SINGLE_REGION =>
      val r = SINGLE_REGION
      r
    case software.amazon.awssdk.services.keyspaces.model.Rs.MULTI_REGION =>
      val r = MULTI_REGION
      r
  }
  case object unknownToSdkVersion extends zio.aws.keyspaces.model.Rs {
    override def unwrap: software.amazon.awssdk.services.keyspaces.model.Rs =
      software.amazon.awssdk.services.keyspaces.model.Rs.UNKNOWN_TO_SDK_VERSION
  }
  case object SINGLE_REGION extends zio.aws.keyspaces.model.Rs {
    override def unwrap: software.amazon.awssdk.services.keyspaces.model.Rs =
      software.amazon.awssdk.services.keyspaces.model.Rs.SINGLE_REGION
  }
  case object MULTI_REGION extends zio.aws.keyspaces.model.Rs {
    override def unwrap: software.amazon.awssdk.services.keyspaces.model.Rs =
      software.amazon.awssdk.services.keyspaces.model.Rs.MULTI_REGION
  }
}
