package zio.aws.keyspaces.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.keyspaces.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.keyspaces.model.SortOrder
  ): zio.aws.keyspaces.model.SortOrder = value match {
    case software.amazon.awssdk.services.keyspaces.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.keyspaces.model.SortOrder.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.keyspaces.model.SortOrder.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion extends zio.aws.keyspaces.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.SortOrder =
      software.amazon.awssdk.services.keyspaces.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.keyspaces.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.SortOrder =
      software.amazon.awssdk.services.keyspaces.model.SortOrder.ASC
  }
  case object DESC extends zio.aws.keyspaces.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.SortOrder =
      software.amazon.awssdk.services.keyspaces.model.SortOrder.DESC
  }
}
