package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.GenericString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StaticColumn(name: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.StaticColumn = {
    import StaticColumn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.StaticColumn
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.StaticColumn.ReadOnly =
    zio.aws.keyspaces.model.StaticColumn.wrap(buildAwsValue())
}
object StaticColumn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.StaticColumn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.StaticColumn =
      zio.aws.keyspaces.model.StaticColumn(name)
    def name: GenericString
    def getName: ZIO[Any, Nothing, GenericString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.StaticColumn
  ) extends zio.aws.keyspaces.model.StaticColumn.ReadOnly {
    override val name: GenericString = impl.name(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.StaticColumn
  ): zio.aws.keyspaces.model.StaticColumn.ReadOnly = new Wrapper(impl)
}
