package zio.aws.keyspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.keyspaces.model.primitives.{
  DoubleObject,
  IntegerObject,
  BooleanObject
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TargetTrackingScalingPolicyConfiguration(
    disableScaleIn: Optional[BooleanObject] = Optional.Absent,
    scaleInCooldown: Optional[IntegerObject] = Optional.Absent,
    scaleOutCooldown: Optional[IntegerObject] = Optional.Absent,
    targetValue: DoubleObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.TargetTrackingScalingPolicyConfiguration = {
    import TargetTrackingScalingPolicyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.TargetTrackingScalingPolicyConfiguration
      .builder()
      .optionallyWith(disableScaleIn.map(value => value: java.lang.Boolean))(
        _.disableScaleIn
      )
      .optionallyWith(scaleInCooldown.map(value => value: Integer))(
        _.scaleInCooldown
      )
      .optionallyWith(scaleOutCooldown.map(value => value: Integer))(
        _.scaleOutCooldown
      )
      .targetValue(targetValue: java.lang.Double)
      .build()
  }
  def asReadOnly
      : zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration
      .wrap(buildAwsValue())
}
object TargetTrackingScalingPolicyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.TargetTrackingScalingPolicyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration =
      zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration(
        disableScaleIn.map(value => value),
        scaleInCooldown.map(value => value),
        scaleOutCooldown.map(value => value),
        targetValue
      )
    def disableScaleIn: Optional[BooleanObject]
    def scaleInCooldown: Optional[IntegerObject]
    def scaleOutCooldown: Optional[IntegerObject]
    def targetValue: DoubleObject
    def getDisableScaleIn: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("disableScaleIn", disableScaleIn)
    def getScaleInCooldown: ZIO[Any, AwsError, IntegerObject] =
      AwsError.unwrapOptionField("scaleInCooldown", scaleInCooldown)
    def getScaleOutCooldown: ZIO[Any, AwsError, IntegerObject] =
      AwsError.unwrapOptionField("scaleOutCooldown", scaleOutCooldown)
    def getTargetValue: ZIO[Any, Nothing, DoubleObject] =
      ZIO.succeed(targetValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.TargetTrackingScalingPolicyConfiguration
  ) extends zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration.ReadOnly {
    override val disableScaleIn: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.disableScaleIn())
      .map(value => value: BooleanObject)
    override val scaleInCooldown: Optional[IntegerObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleInCooldown())
        .map(value => value: IntegerObject)
    override val scaleOutCooldown: Optional[IntegerObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleOutCooldown())
        .map(value => value: IntegerObject)
    override val targetValue: DoubleObject = impl.targetValue(): DoubleObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.TargetTrackingScalingPolicyConfiguration
  ): zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    new Wrapper(impl)
}
