package zio.aws.keyspaces.model
import scala.jdk.CollectionConverters._
sealed trait ThroughputMode {
  def unwrap: software.amazon.awssdk.services.keyspaces.model.ThroughputMode
}
object ThroughputMode {
  def wrap(
      value: software.amazon.awssdk.services.keyspaces.model.ThroughputMode
  ): zio.aws.keyspaces.model.ThroughputMode = value match {
    case software.amazon.awssdk.services.keyspaces.model.ThroughputMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.keyspaces.model.ThroughputMode.PAY_PER_REQUEST =>
      val r = PAY_PER_REQUEST
      r
    case software.amazon.awssdk.services.keyspaces.model.ThroughputMode.PROVISIONED =>
      val r = PROVISIONED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.keyspaces.model.ThroughputMode {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.ThroughputMode =
      software.amazon.awssdk.services.keyspaces.model.ThroughputMode.UNKNOWN_TO_SDK_VERSION
  }
  case object PAY_PER_REQUEST extends zio.aws.keyspaces.model.ThroughputMode {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.ThroughputMode =
      software.amazon.awssdk.services.keyspaces.model.ThroughputMode.PAY_PER_REQUEST
  }
  case object PROVISIONED extends zio.aws.keyspaces.model.ThroughputMode {
    override def unwrap
        : software.amazon.awssdk.services.keyspaces.model.ThroughputMode =
      software.amazon.awssdk.services.keyspaces.model.ThroughputMode.PROVISIONED
  }
}
