package zio.aws.keyspaces
import zio.aws.keyspaces.model.ListTagsForResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.keyspaces.model.{
  GetTableRequest,
  ListTagsForResourceRequest,
  DeleteKeyspaceRequest,
  UpdateTableRequest,
  CreateTableRequest,
  CreateKeyspaceRequest,
  GetTableAutoScalingSettingsRequest,
  GetKeyspaceRequest,
  UntagResourceRequest,
  DeleteTableRequest,
  ListKeyspacesRequest,
  RestoreTableRequest,
  ListTablesRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.keyspaces.KeyspacesAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object KeyspacesMock extends Mock[Keyspaces] {
  object GetTable
      extends Effect[
        GetTableRequest,
        AwsError,
        zio.aws.keyspaces.model.GetTableResponse.ReadOnly
      ]
  object DeleteKeyspace
      extends Effect[
        DeleteKeyspaceRequest,
        AwsError,
        zio.aws.keyspaces.model.DeleteKeyspaceResponse.ReadOnly
      ]
  object CreateTable
      extends Effect[
        CreateTableRequest,
        AwsError,
        zio.aws.keyspaces.model.CreateTableResponse.ReadOnly
      ]
  object DeleteTable
      extends Effect[
        DeleteTableRequest,
        AwsError,
        zio.aws.keyspaces.model.DeleteTableResponse.ReadOnly
      ]
  object ListKeyspaces
      extends Stream[
        ListKeyspacesRequest,
        AwsError,
        zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly
      ]
  object ListKeyspacesPaginated
      extends Effect[
        ListKeyspacesRequest,
        AwsError,
        zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly
      ]
  object GetKeyspace
      extends Effect[
        GetKeyspaceRequest,
        AwsError,
        zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly
      ]
  object ListTables
      extends Stream[
        ListTablesRequest,
        AwsError,
        zio.aws.keyspaces.model.TableSummary.ReadOnly
      ]
  object ListTablesPaginated
      extends Effect[
        ListTablesRequest,
        AwsError,
        zio.aws.keyspaces.model.ListTablesResponse.ReadOnly
      ]
  object UpdateTable
      extends Effect[
        UpdateTableRequest,
        AwsError,
        zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.keyspaces.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.keyspaces.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[ListTagsForResourceRequest, AwsError, ReadOnly]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.keyspaces.model.TagResourceResponse.ReadOnly
      ]
  object RestoreTable
      extends Effect[
        RestoreTableRequest,
        AwsError,
        zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly
      ]
  object CreateKeyspace
      extends Effect[
        CreateKeyspaceRequest,
        AwsError,
        zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly
      ]
  object GetTableAutoScalingSettings
      extends Effect[
        GetTableAutoScalingSettingsRequest,
        AwsError,
        zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Keyspaces] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Keyspaces] { rts =>
        zio.ZIO.succeed {
          new Keyspaces {
            val api: KeyspacesAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Keyspaces = this
            def getTable(
                request: GetTableRequest
            ): IO[AwsError, zio.aws.keyspaces.model.GetTableResponse.ReadOnly] =
              proxy(GetTable, request)
            def deleteKeyspace(request: DeleteKeyspaceRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.DeleteKeyspaceResponse.ReadOnly
            ] = proxy(DeleteKeyspace, request)
            def createTable(request: CreateTableRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.CreateTableResponse.ReadOnly
            ] = proxy(CreateTable, request)
            def deleteTable(request: DeleteTableRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.DeleteTableResponse.ReadOnly
            ] = proxy(DeleteTable, request)
            def listKeyspaces(request: ListKeyspacesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.keyspaces.model.KeyspaceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListKeyspaces, request)
                }
                .getOrThrowFiberFailure()
            }
            def listKeyspacesPaginated(request: ListKeyspacesRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.ListKeyspacesResponse.ReadOnly
            ] = proxy(ListKeyspacesPaginated, request)
            def getKeyspace(request: GetKeyspaceRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.GetKeyspaceResponse.ReadOnly
            ] = proxy(GetKeyspace, request)
            def listTables(request: ListTablesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.keyspaces.model.TableSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTables, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTablesPaginated(request: ListTablesRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.ListTablesResponse.ReadOnly
            ] = proxy(ListTablesPaginated, request)
            def updateTable(request: UpdateTableRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.UpdateTableResponse.ReadOnly
            ] = proxy(UpdateTable, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.keyspaces.model.Tag.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTagsForResource, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListTagsForResourcePaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def restoreTable(request: RestoreTableRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.RestoreTableResponse.ReadOnly
            ] = proxy(RestoreTable, request)
            def createKeyspace(request: CreateKeyspaceRequest): IO[
              AwsError,
              zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly
            ] = proxy(CreateKeyspace, request)
            def getTableAutoScalingSettings(
                request: GetTableAutoScalingSettingsRequest
            ): IO[
              AwsError,
              zio.aws.keyspaces.model.GetTableAutoScalingSettingsResponse.ReadOnly
            ] = proxy(GetTableAutoScalingSettings, request)
          }
        }
      }
    }
  }
}
