package zio.aws.keyspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingPolicy(
    targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.AutoScalingPolicy = {
    import AutoScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.AutoScalingPolicy
      .builder()
      .optionallyWith(
        targetTrackingScalingPolicyConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.targetTrackingScalingPolicyConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.AutoScalingPolicy.ReadOnly =
    zio.aws.keyspaces.model.AutoScalingPolicy.wrap(buildAwsValue())
}
object AutoScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.AutoScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.AutoScalingPolicy =
      zio.aws.keyspaces.model.AutoScalingPolicy(
        targetTrackingScalingPolicyConfiguration.map(value => value.asEditable)
      )
    def targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ]
    def getTargetTrackingScalingPolicyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetTrackingScalingPolicyConfiguration",
      targetTrackingScalingPolicyConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.AutoScalingPolicy
  ) extends zio.aws.keyspaces.model.AutoScalingPolicy.ReadOnly {
    override val targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetTrackingScalingPolicyConfiguration())
      .map(value =>
        zio.aws.keyspaces.model.TargetTrackingScalingPolicyConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.AutoScalingPolicy
  ): zio.aws.keyspaces.model.AutoScalingPolicy.ReadOnly = new Wrapper(impl)
}
