package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{CapacityUnits, BooleanObject}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingSettings(
    autoScalingDisabled: Optional[BooleanObject] = Optional.Absent,
    minimumUnits: Optional[CapacityUnits] = Optional.Absent,
    maximumUnits: Optional[CapacityUnits] = Optional.Absent,
    scalingPolicy: Optional[zio.aws.keyspaces.model.AutoScalingPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.AutoScalingSettings = {
    import AutoScalingSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.AutoScalingSettings
      .builder()
      .optionallyWith(
        autoScalingDisabled.map(value => value: java.lang.Boolean)
      )(_.autoScalingDisabled)
      .optionallyWith(
        minimumUnits.map(value => CapacityUnits.unwrap(value): java.lang.Long)
      )(_.minimumUnits)
      .optionallyWith(
        maximumUnits.map(value => CapacityUnits.unwrap(value): java.lang.Long)
      )(_.maximumUnits)
      .optionallyWith(scalingPolicy.map(value => value.buildAwsValue()))(
        _.scalingPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly =
    zio.aws.keyspaces.model.AutoScalingSettings.wrap(buildAwsValue())
}
object AutoScalingSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.AutoScalingSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.AutoScalingSettings =
      zio.aws.keyspaces.model.AutoScalingSettings(
        autoScalingDisabled.map(value => value),
        minimumUnits.map(value => value),
        maximumUnits.map(value => value),
        scalingPolicy.map(value => value.asEditable)
      )
    def autoScalingDisabled: Optional[BooleanObject]
    def minimumUnits: Optional[CapacityUnits]
    def maximumUnits: Optional[CapacityUnits]
    def scalingPolicy
        : Optional[zio.aws.keyspaces.model.AutoScalingPolicy.ReadOnly]
    def getAutoScalingDisabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingDisabled", autoScalingDisabled)
    def getMinimumUnits: ZIO[Any, AwsError, CapacityUnits] =
      AwsError.unwrapOptionField("minimumUnits", minimumUnits)
    def getMaximumUnits: ZIO[Any, AwsError, CapacityUnits] =
      AwsError.unwrapOptionField("maximumUnits", maximumUnits)
    def getScalingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.AutoScalingPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("scalingPolicy", scalingPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.AutoScalingSettings
  ) extends zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly {
    override val autoScalingDisabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingDisabled())
        .map(value => value: BooleanObject)
    override val minimumUnits: Optional[CapacityUnits] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumUnits())
      .map(value => zio.aws.keyspaces.model.primitives.CapacityUnits(value))
    override val maximumUnits: Optional[CapacityUnits] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumUnits())
      .map(value => zio.aws.keyspaces.model.primitives.CapacityUnits(value))
    override val scalingPolicy
        : Optional[zio.aws.keyspaces.model.AutoScalingPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPolicy())
        .map(value => zio.aws.keyspaces.model.AutoScalingPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.AutoScalingSettings
  ): zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly = new Wrapper(impl)
}
