package zio.aws.keyspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingSpecification(
    writeCapacityAutoScaling: Optional[
      zio.aws.keyspaces.model.AutoScalingSettings
    ] = Optional.Absent,
    readCapacityAutoScaling: Optional[
      zio.aws.keyspaces.model.AutoScalingSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.AutoScalingSpecification = {
    import AutoScalingSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.AutoScalingSpecification
      .builder()
      .optionallyWith(
        writeCapacityAutoScaling.map(value => value.buildAwsValue())
      )(_.writeCapacityAutoScaling)
      .optionallyWith(
        readCapacityAutoScaling.map(value => value.buildAwsValue())
      )(_.readCapacityAutoScaling)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly =
    zio.aws.keyspaces.model.AutoScalingSpecification.wrap(buildAwsValue())
}
object AutoScalingSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.AutoScalingSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.AutoScalingSpecification =
      zio.aws.keyspaces.model.AutoScalingSpecification(
        writeCapacityAutoScaling.map(value => value.asEditable),
        readCapacityAutoScaling.map(value => value.asEditable)
      )
    def writeCapacityAutoScaling
        : Optional[zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly]
    def readCapacityAutoScaling
        : Optional[zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly]
    def getWriteCapacityAutoScaling: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "writeCapacityAutoScaling",
      writeCapacityAutoScaling
    )
    def getReadCapacityAutoScaling: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "readCapacityAutoScaling",
      readCapacityAutoScaling
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.AutoScalingSpecification
  ) extends zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly {
    override val writeCapacityAutoScaling
        : Optional[zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeCapacityAutoScaling())
        .map(value => zio.aws.keyspaces.model.AutoScalingSettings.wrap(value))
    override val readCapacityAutoScaling
        : Optional[zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readCapacityAutoScaling())
        .map(value => zio.aws.keyspaces.model.AutoScalingSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.AutoScalingSpecification
  ): zio.aws.keyspaces.model.AutoScalingSpecification.ReadOnly = new Wrapper(
    impl
  )
}
