package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateKeyspaceResponse(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse = {
    import CreateKeyspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly =
    zio.aws.keyspaces.model.CreateKeyspaceResponse.wrap(buildAwsValue())
}
object CreateKeyspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.CreateKeyspaceResponse =
      zio.aws.keyspaces.model.CreateKeyspaceResponse(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse
  ) extends zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.keyspaces.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse
  ): zio.aws.keyspaces.model.CreateKeyspaceResponse.ReadOnly = new Wrapper(impl)
}
