package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.{CapacityUnits, Region}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaSpecification(
    region: Region,
    readCapacityUnits: Optional[CapacityUnits] = Optional.Absent,
    readCapacityAutoScaling: Optional[
      zio.aws.keyspaces.model.AutoScalingSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification = {
    import ReplicaSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification
      .builder()
      .region(Region.unwrap(region): java.lang.String)
      .optionallyWith(
        readCapacityUnits.map(value =>
          CapacityUnits.unwrap(value): java.lang.Long
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        readCapacityAutoScaling.map(value => value.buildAwsValue())
      )(_.readCapacityAutoScaling)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ReplicaSpecification.ReadOnly =
    zio.aws.keyspaces.model.ReplicaSpecification.wrap(buildAwsValue())
}
object ReplicaSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ReplicaSpecification =
      zio.aws.keyspaces.model.ReplicaSpecification(
        region,
        readCapacityUnits.map(value => value),
        readCapacityAutoScaling.map(value => value.asEditable)
      )
    def region: Region
    def readCapacityUnits: Optional[CapacityUnits]
    def readCapacityAutoScaling
        : Optional[zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly]
    def getRegion: ZIO[Any, Nothing, Region] = ZIO.succeed(region)
    def getReadCapacityUnits: ZIO[Any, AwsError, CapacityUnits] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getReadCapacityAutoScaling: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "readCapacityAutoScaling",
      readCapacityAutoScaling
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification
  ) extends zio.aws.keyspaces.model.ReplicaSpecification.ReadOnly {
    override val region: Region =
      zio.aws.keyspaces.model.primitives.Region(impl.region())
    override val readCapacityUnits: Optional[CapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readCapacityUnits())
        .map(value => zio.aws.keyspaces.model.primitives.CapacityUnits(value))
    override val readCapacityAutoScaling
        : Optional[zio.aws.keyspaces.model.AutoScalingSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readCapacityAutoScaling())
        .map(value => zio.aws.keyspaces.model.AutoScalingSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicaSpecification
  ): zio.aws.keyspaces.model.ReplicaSpecification.ReadOnly = new Wrapper(impl)
}
