package zio.aws.keyspaces.model
import zio.aws.keyspaces.model.primitives.Region
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaSpecificationSummary(
    region: Optional[Region] = Optional.Absent,
    status: Optional[zio.aws.keyspaces.model.TableStatus] = Optional.Absent,
    capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecificationSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.keyspaces.model.ReplicaSpecificationSummary = {
    import ReplicaSpecificationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.keyspaces.model.ReplicaSpecificationSummary
      .builder()
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        capacitySpecification.map(value => value.buildAwsValue())
      )(_.capacitySpecification)
      .build()
  }
  def asReadOnly: zio.aws.keyspaces.model.ReplicaSpecificationSummary.ReadOnly =
    zio.aws.keyspaces.model.ReplicaSpecificationSummary.wrap(buildAwsValue())
}
object ReplicaSpecificationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.keyspaces.model.ReplicaSpecificationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.keyspaces.model.ReplicaSpecificationSummary =
      zio.aws.keyspaces.model.ReplicaSpecificationSummary(
        region.map(value => value),
        status.map(value => value),
        capacitySpecification.map(value => value.asEditable)
      )
    def region: Optional[Region]
    def status: Optional[zio.aws.keyspaces.model.TableStatus]
    def capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly
    ]
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getStatus: ZIO[Any, AwsError, zio.aws.keyspaces.model.TableStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly
    ] =
      AwsError.unwrapOptionField("capacitySpecification", capacitySpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicaSpecificationSummary
  ) extends zio.aws.keyspaces.model.ReplicaSpecificationSummary.ReadOnly {
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.keyspaces.model.primitives.Region(value))
    override val status: Optional[zio.aws.keyspaces.model.TableStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.keyspaces.model.TableStatus.wrap(value))
    override val capacitySpecification: Optional[
      zio.aws.keyspaces.model.CapacitySpecificationSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacitySpecification())
      .map(value =>
        zio.aws.keyspaces.model.CapacitySpecificationSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.keyspaces.model.ReplicaSpecificationSummary
  ): zio.aws.keyspaces.model.ReplicaSpecificationSummary.ReadOnly = new Wrapper(
    impl
  )
}
