package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{TagValue, TagKey, StreamName}
import scala.jdk.CollectionConverters._
final case class AddTagsToStreamRequest(
    streamName: StreamName,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest = {
    import AddTagsToStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.AddTagsToStreamRequest.ReadOnly =
    zio.aws.kinesis.model.AddTagsToStreamRequest.wrap(buildAwsValue())
}
object AddTagsToStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.AddTagsToStreamRequest =
      zio.aws.kinesis.model.AddTagsToStreamRequest(streamName, tags)
    def streamName: StreamName
    def tags: Map[TagKey, TagValue]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
  ) extends zio.aws.kinesis.model.AddTagsToStreamRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.kinesis.model.primitives
          .TagKey(key) -> zio.aws.kinesis.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
  ): zio.aws.kinesis.model.AddTagsToStreamRequest.ReadOnly = new Wrapper(impl)
}
