package zio.aws.kinesis.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{RetentionPeriodHours, StreamName}
import scala.jdk.CollectionConverters._
final case class DecreaseStreamRetentionPeriodRequest(
    streamName: StreamName,
    retentionPeriodHours: RetentionPeriodHours
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest = {
    import DecreaseStreamRetentionPeriodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .retentionPeriodHours(
        RetentionPeriodHours.unwrap(retentionPeriodHours): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest.ReadOnly =
    zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest
      .wrap(buildAwsValue())
}
object DecreaseStreamRetentionPeriodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest =
      zio.aws.kinesis.model
        .DecreaseStreamRetentionPeriodRequest(streamName, retentionPeriodHours)
    def streamName: StreamName
    def retentionPeriodHours: RetentionPeriodHours
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getRetentionPeriodHours: ZIO[Any, Nothing, RetentionPeriodHours] =
      ZIO.succeed(retentionPeriodHours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ) extends zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val retentionPeriodHours: RetentionPeriodHours =
      zio.aws.kinesis.model.primitives
        .RetentionPeriodHours(impl.retentionPeriodHours())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ): zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest.ReadOnly =
    new Wrapper(impl)
}
