package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{ConsumerARN, ConsumerName, StreamARN}
import scala.jdk.CollectionConverters._
final case class DeregisterStreamConsumerRequest(
    streamARN: Optional[StreamARN] = Optional.Absent,
    consumerName: Optional[ConsumerName] = Optional.Absent,
    consumerARN: Optional[ConsumerARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest = {
    import DeregisterStreamConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest
      .builder()
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .optionallyWith(
        consumerName.map(value => ConsumerName.unwrap(value): java.lang.String)
      )(_.consumerName)
      .optionallyWith(
        consumerARN.map(value => ConsumerARN.unwrap(value): java.lang.String)
      )(_.consumerARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.DeregisterStreamConsumerRequest.ReadOnly =
    zio.aws.kinesis.model.DeregisterStreamConsumerRequest.wrap(buildAwsValue())
}
object DeregisterStreamConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DeregisterStreamConsumerRequest =
      zio.aws.kinesis.model.DeregisterStreamConsumerRequest(
        streamARN.map(value => value),
        consumerName.map(value => value),
        consumerARN.map(value => value)
      )
    def streamARN: Optional[StreamARN]
    def consumerName: Optional[ConsumerName]
    def consumerARN: Optional[ConsumerARN]
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getConsumerName: ZIO[Any, AwsError, ConsumerName] =
      AwsError.unwrapOptionField("consumerName", consumerName)
    def getConsumerARN: ZIO[Any, AwsError, ConsumerARN] =
      AwsError.unwrapOptionField("consumerARN", consumerARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest
  ) extends zio.aws.kinesis.model.DeregisterStreamConsumerRequest.ReadOnly {
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
    override val consumerName: Optional[ConsumerName] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerName())
      .map(value => zio.aws.kinesis.model.primitives.ConsumerName(value))
    override val consumerARN: Optional[ConsumerARN] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerARN())
      .map(value => zio.aws.kinesis.model.primitives.ConsumerARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest
  ): zio.aws.kinesis.model.DeregisterStreamConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
