package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStreamConsumerResponse(
    consumerDescription: zio.aws.kinesis.model.ConsumerDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse = {
    import DescribeStreamConsumerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse
      .builder()
      .consumerDescription(consumerDescription.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamConsumerResponse.wrap(buildAwsValue())
}
object DescribeStreamConsumerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamConsumerResponse =
      zio.aws.kinesis.model
        .DescribeStreamConsumerResponse(consumerDescription.asEditable)
    def consumerDescription: zio.aws.kinesis.model.ConsumerDescription.ReadOnly
    def getConsumerDescription: ZIO[
      Any,
      Nothing,
      zio.aws.kinesis.model.ConsumerDescription.ReadOnly
    ] = ZIO.succeed(consumerDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse
  ) extends zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly {
    override val consumerDescription
        : zio.aws.kinesis.model.ConsumerDescription.ReadOnly =
      zio.aws.kinesis.model.ConsumerDescription.wrap(impl.consumerDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse
  ): zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly =
    new Wrapper(impl)
}
