package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStreamResponse(
    streamDescription: zio.aws.kinesis.model.StreamDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse = {
    import DescribeStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse
      .builder()
      .streamDescription(streamDescription.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamResponse.wrap(buildAwsValue())
}
object DescribeStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamResponse =
      zio.aws.kinesis.model.DescribeStreamResponse(streamDescription.asEditable)
    def streamDescription: zio.aws.kinesis.model.StreamDescription.ReadOnly
    def getStreamDescription
        : ZIO[Any, Nothing, zio.aws.kinesis.model.StreamDescription.ReadOnly] =
      ZIO.succeed(streamDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse
  ) extends zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly {
    override val streamDescription
        : zio.aws.kinesis.model.StreamDescription.ReadOnly =
      zio.aws.kinesis.model.StreamDescription.wrap(impl.streamDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse
  ): zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly = new Wrapper(impl)
}
