package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  Timestamp,
  SequenceNumber,
  ShardId,
  StreamName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetShardIteratorRequest(
    streamName: StreamName,
    shardId: ShardId,
    shardIteratorType: zio.aws.kinesis.model.ShardIteratorType,
    startingSequenceNumber: Optional[SequenceNumber] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest = {
    import GetShardIteratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .shardId(ShardId.unwrap(shardId): java.lang.String)
      .shardIteratorType(shardIteratorType.unwrap)
      .optionallyWith(
        startingSequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.startingSequenceNumber)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.GetShardIteratorRequest.ReadOnly =
    zio.aws.kinesis.model.GetShardIteratorRequest.wrap(buildAwsValue())
}
object GetShardIteratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.GetShardIteratorRequest =
      zio.aws.kinesis.model.GetShardIteratorRequest(
        streamName,
        shardId,
        shardIteratorType,
        startingSequenceNumber.map(value => value),
        timestamp.map(value => value)
      )
    def streamName: StreamName
    def shardId: ShardId
    def shardIteratorType: zio.aws.kinesis.model.ShardIteratorType
    def startingSequenceNumber: Optional[SequenceNumber]
    def timestamp: Optional[Timestamp]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getShardId: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardId)
    def getShardIteratorType
        : ZIO[Any, Nothing, zio.aws.kinesis.model.ShardIteratorType] =
      ZIO.succeed(shardIteratorType)
    def getStartingSequenceNumber: ZIO[Any, AwsError, SequenceNumber] = AwsError
      .unwrapOptionField("startingSequenceNumber", startingSequenceNumber)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest
  ) extends zio.aws.kinesis.model.GetShardIteratorRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val shardId: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardId())
    override val shardIteratorType: zio.aws.kinesis.model.ShardIteratorType =
      zio.aws.kinesis.model.ShardIteratorType.wrap(impl.shardIteratorType())
    override val startingSequenceNumber: Optional[SequenceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingSequenceNumber())
        .map(value => zio.aws.kinesis.model.primitives.SequenceNumber(value))
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest
  ): zio.aws.kinesis.model.GetShardIteratorRequest.ReadOnly = new Wrapper(impl)
}
