package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.ShardIterator
import scala.jdk.CollectionConverters._
final case class GetShardIteratorResponse(
    shardIterator: Optional[ShardIterator] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse = {
    import GetShardIteratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse
      .builder()
      .optionallyWith(
        shardIterator.map(value =>
          ShardIterator.unwrap(value): java.lang.String
        )
      )(_.shardIterator)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly =
    zio.aws.kinesis.model.GetShardIteratorResponse.wrap(buildAwsValue())
}
object GetShardIteratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.GetShardIteratorResponse =
      zio.aws.kinesis.model
        .GetShardIteratorResponse(shardIterator.map(value => value))
    def shardIterator: Optional[ShardIterator]
    def getShardIterator: ZIO[Any, AwsError, ShardIterator] =
      AwsError.unwrapOptionField("shardIterator", shardIterator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse
  ) extends zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly {
    override val shardIterator: Optional[ShardIterator] = zio.aws.core.internal
      .optionalFromNullable(impl.shardIterator())
      .map(value => zio.aws.kinesis.model.primitives.ShardIterator(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse
  ): zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly = new Wrapper(impl)
}
