package zio.aws.kinesis.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{RetentionPeriodHours, StreamName}
import scala.jdk.CollectionConverters._
final case class IncreaseStreamRetentionPeriodRequest(
    streamName: StreamName,
    retentionPeriodHours: RetentionPeriodHours
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest = {
    import IncreaseStreamRetentionPeriodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .retentionPeriodHours(
        RetentionPeriodHours.unwrap(retentionPeriodHours): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest.ReadOnly =
    zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest
      .wrap(buildAwsValue())
}
object IncreaseStreamRetentionPeriodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest =
      zio.aws.kinesis.model
        .IncreaseStreamRetentionPeriodRequest(streamName, retentionPeriodHours)
    def streamName: StreamName
    def retentionPeriodHours: RetentionPeriodHours
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getRetentionPeriodHours: ZIO[Any, Nothing, RetentionPeriodHours] =
      ZIO.succeed(retentionPeriodHours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ) extends zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val retentionPeriodHours: RetentionPeriodHours =
      zio.aws.kinesis.model.primitives
        .RetentionPeriodHours(impl.retentionPeriodHours())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ): zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest.ReadOnly =
    new Wrapper(impl)
}
