package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  Timestamp,
  ListStreamConsumersInputLimit,
  NextToken,
  StreamARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStreamConsumersRequest(
    streamARN: StreamARN,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListStreamConsumersInputLimit] = Optional.Absent,
    streamCreationTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest = {
    import ListStreamConsumersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest
      .builder()
      .streamARN(StreamARN.unwrap(streamARN): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListStreamConsumersInputLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        streamCreationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.streamCreationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListStreamConsumersRequest.ReadOnly =
    zio.aws.kinesis.model.ListStreamConsumersRequest.wrap(buildAwsValue())
}
object ListStreamConsumersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListStreamConsumersRequest =
      zio.aws.kinesis.model.ListStreamConsumersRequest(
        streamARN,
        nextToken.map(value => value),
        maxResults.map(value => value),
        streamCreationTimestamp.map(value => value)
      )
    def streamARN: StreamARN
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListStreamConsumersInputLimit]
    def streamCreationTimestamp: Optional[Timestamp]
    def getStreamARN: ZIO[Any, Nothing, StreamARN] = ZIO.succeed(streamARN)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListStreamConsumersInputLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStreamCreationTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("streamCreationTimestamp", streamCreationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest
  ) extends zio.aws.kinesis.model.ListStreamConsumersRequest.ReadOnly {
    override val streamARN: StreamARN =
      zio.aws.kinesis.model.primitives.StreamARN(impl.streamARN())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
    override val maxResults: Optional[ListStreamConsumersInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kinesis.model.primitives.ListStreamConsumersInputLimit(value)
        )
    override val streamCreationTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamCreationTimestamp())
        .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest
  ): zio.aws.kinesis.model.ListStreamConsumersRequest.ReadOnly = new Wrapper(
    impl
  )
}
