package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListStreamConsumersResponse(
    consumers: Optional[Iterable[zio.aws.kinesis.model.Consumer]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse = {
    import ListStreamConsumersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
      .builder()
      .optionallyWith(
        consumers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly =
    zio.aws.kinesis.model.ListStreamConsumersResponse.wrap(buildAwsValue())
}
object ListStreamConsumersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListStreamConsumersResponse =
      zio.aws.kinesis.model.ListStreamConsumersResponse(
        consumers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def consumers: Optional[List[zio.aws.kinesis.model.Consumer.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConsumers
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.Consumer.ReadOnly]] =
      AwsError.unwrapOptionField("consumers", consumers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
  ) extends zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly {
    override val consumers
        : Optional[List[zio.aws.kinesis.model.Consumer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.Consumer.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse
  ): zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly = new Wrapper(
    impl
  )
}
