package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  ListTagsForStreamInputLimit,
  TagKey,
  StreamName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTagsForStreamRequest(
    streamName: StreamName,
    exclusiveStartTagKey: Optional[TagKey] = Optional.Absent,
    limit: Optional[ListTagsForStreamInputLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest = {
    import ListTagsForStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .optionallyWith(
        exclusiveStartTagKey.map(value =>
          TagKey.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartTagKey)
      .optionallyWith(
        limit.map(value => ListTagsForStreamInputLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly =
    zio.aws.kinesis.model.ListTagsForStreamRequest.wrap(buildAwsValue())
}
object ListTagsForStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListTagsForStreamRequest =
      zio.aws.kinesis.model.ListTagsForStreamRequest(
        streamName,
        exclusiveStartTagKey.map(value => value),
        limit.map(value => value)
      )
    def streamName: StreamName
    def exclusiveStartTagKey: Optional[TagKey]
    def limit: Optional[ListTagsForStreamInputLimit]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getExclusiveStartTagKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("exclusiveStartTagKey", exclusiveStartTagKey)
    def getLimit: ZIO[Any, AwsError, ListTagsForStreamInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ) extends zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val exclusiveStartTagKey: Optional[TagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusiveStartTagKey())
      .map(value => zio.aws.kinesis.model.primitives.TagKey(value))
    override val limit: Optional[ListTagsForStreamInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.kinesis.model.primitives.ListTagsForStreamInputLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ): zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly = new Wrapper(impl)
}
