package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{SequenceNumber, ShardId}
import scala.jdk.CollectionConverters._
final case class PutRecordResponse(
    shardId: ShardId,
    sequenceNumber: SequenceNumber,
    encryptionType: Optional[zio.aws.kinesis.model.EncryptionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordResponse = {
    import PutRecordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordResponse
      .builder()
      .shardId(ShardId.unwrap(shardId): java.lang.String)
      .sequenceNumber(SequenceNumber.unwrap(sequenceNumber): java.lang.String)
      .optionallyWith(encryptionType.map(value => value.unwrap))(
        _.encryptionType
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordResponse.ReadOnly =
    zio.aws.kinesis.model.PutRecordResponse.wrap(buildAwsValue())
}
object PutRecordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordResponse =
      zio.aws.kinesis.model.PutRecordResponse(
        shardId,
        sequenceNumber,
        encryptionType.map(value => value)
      )
    def shardId: ShardId
    def sequenceNumber: SequenceNumber
    def encryptionType: Optional[zio.aws.kinesis.model.EncryptionType]
    def getShardId: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardId)
    def getSequenceNumber: ZIO[Any, Nothing, SequenceNumber] =
      ZIO.succeed(sequenceNumber)
    def getEncryptionType
        : ZIO[Any, AwsError, zio.aws.kinesis.model.EncryptionType] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordResponse
  ) extends zio.aws.kinesis.model.PutRecordResponse.ReadOnly {
    override val shardId: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardId())
    override val sequenceNumber: SequenceNumber =
      zio.aws.kinesis.model.primitives.SequenceNumber(impl.sequenceNumber())
    override val encryptionType
        : Optional[zio.aws.kinesis.model.EncryptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionType())
      .map(value => zio.aws.kinesis.model.EncryptionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordResponse
  ): zio.aws.kinesis.model.PutRecordResponse.ReadOnly = new Wrapper(impl)
}
