package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{
  ErrorMessage,
  ErrorCode,
  ShardId,
  SequenceNumber
}
import scala.jdk.CollectionConverters._
final case class PutRecordsResultEntry(
    sequenceNumber: Optional[SequenceNumber] = Optional.Absent,
    shardId: Optional[ShardId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry = {
    import PutRecordsResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry
      .builder()
      .optionallyWith(
        sequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.sequenceNumber)
      .optionallyWith(
        shardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.shardId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordsResultEntry.ReadOnly =
    zio.aws.kinesis.model.PutRecordsResultEntry.wrap(buildAwsValue())
}
object PutRecordsResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordsResultEntry =
      zio.aws.kinesis.model.PutRecordsResultEntry(
        sequenceNumber.map(value => value),
        shardId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def sequenceNumber: Optional[SequenceNumber]
    def shardId: Optional[ShardId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getSequenceNumber: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
    def getShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("shardId", shardId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry
  ) extends zio.aws.kinesis.model.PutRecordsResultEntry.ReadOnly {
    override val sequenceNumber: Optional[SequenceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceNumber())
        .map(value => zio.aws.kinesis.model.primitives.SequenceNumber(value))
    override val shardId: Optional[ShardId] = zio.aws.core.internal
      .optionalFromNullable(impl.shardId())
      .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.kinesis.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kinesis.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry
  ): zio.aws.kinesis.model.PutRecordsResultEntry.ReadOnly = new Wrapper(impl)
}
