package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{ConsumerName, StreamARN}
import scala.jdk.CollectionConverters._
final case class RegisterStreamConsumerRequest(
    streamARN: StreamARN,
    consumerName: ConsumerName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest = {
    import RegisterStreamConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest
      .builder()
      .streamARN(StreamARN.unwrap(streamARN): java.lang.String)
      .consumerName(ConsumerName.unwrap(consumerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.RegisterStreamConsumerRequest.ReadOnly =
    zio.aws.kinesis.model.RegisterStreamConsumerRequest.wrap(buildAwsValue())
}
object RegisterStreamConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.RegisterStreamConsumerRequest =
      zio.aws.kinesis.model
        .RegisterStreamConsumerRequest(streamARN, consumerName)
    def streamARN: StreamARN
    def consumerName: ConsumerName
    def getStreamARN: ZIO[Any, Nothing, StreamARN] = ZIO.succeed(streamARN)
    def getConsumerName: ZIO[Any, Nothing, ConsumerName] =
      ZIO.succeed(consumerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest
  ) extends zio.aws.kinesis.model.RegisterStreamConsumerRequest.ReadOnly {
    override val streamARN: StreamARN =
      zio.aws.kinesis.model.primitives.StreamARN(impl.streamARN())
    override val consumerName: ConsumerName =
      zio.aws.kinesis.model.primitives.ConsumerName(impl.consumerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest
  ): zio.aws.kinesis.model.RegisterStreamConsumerRequest.ReadOnly = new Wrapper(
    impl
  )
}
