package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{TagKey, StreamName}
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromStreamRequest(
    streamName: StreamName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest = {
    import RemoveTagsFromStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.RemoveTagsFromStreamRequest.ReadOnly =
    zio.aws.kinesis.model.RemoveTagsFromStreamRequest.wrap(buildAwsValue())
}
object RemoveTagsFromStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.RemoveTagsFromStreamRequest =
      zio.aws.kinesis.model.RemoveTagsFromStreamRequest(streamName, tagKeys)
    def streamName: StreamName
    def tagKeys: List[TagKey]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
  ) extends zio.aws.kinesis.model.RemoveTagsFromStreamRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest
  ): zio.aws.kinesis.model.RemoveTagsFromStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
