package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{HashKey, ShardId, StreamName}
import scala.jdk.CollectionConverters._
final case class SplitShardRequest(
    streamName: StreamName,
    shardToSplit: ShardId,
    newStartingHashKey: HashKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.SplitShardRequest = {
    import SplitShardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.SplitShardRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .shardToSplit(ShardId.unwrap(shardToSplit): java.lang.String)
      .newStartingHashKey(HashKey.unwrap(newStartingHashKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.SplitShardRequest.ReadOnly =
    zio.aws.kinesis.model.SplitShardRequest.wrap(buildAwsValue())
}
object SplitShardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.SplitShardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.SplitShardRequest =
      zio.aws.kinesis.model
        .SplitShardRequest(streamName, shardToSplit, newStartingHashKey)
    def streamName: StreamName
    def shardToSplit: ShardId
    def newStartingHashKey: HashKey
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getShardToSplit: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardToSplit)
    def getNewStartingHashKey: ZIO[Any, Nothing, HashKey] =
      ZIO.succeed(newStartingHashKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.SplitShardRequest
  ) extends zio.aws.kinesis.model.SplitShardRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val shardToSplit: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardToSplit())
    override val newStartingHashKey: HashKey =
      zio.aws.kinesis.model.primitives.HashKey(impl.newStartingHashKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.SplitShardRequest
  ): zio.aws.kinesis.model.SplitShardRequest.ReadOnly = new Wrapper(impl)
}
