package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{Timestamp, SequenceNumber}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartingPosition(
    `type`: zio.aws.kinesis.model.ShardIteratorType,
    sequenceNumber: Optional[SequenceNumber] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.StartingPosition = {
    import StartingPosition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.StartingPosition
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        sequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.sequenceNumber)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.StartingPosition.ReadOnly =
    zio.aws.kinesis.model.StartingPosition.wrap(buildAwsValue())
}
object StartingPosition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.StartingPosition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.StartingPosition =
      zio.aws.kinesis.model.StartingPosition(
        `type`,
        sequenceNumber.map(value => value),
        timestamp.map(value => value)
      )
    def `type`: zio.aws.kinesis.model.ShardIteratorType
    def sequenceNumber: Optional[SequenceNumber]
    def timestamp: Optional[Timestamp]
    def getType: ZIO[Any, Nothing, zio.aws.kinesis.model.ShardIteratorType] =
      ZIO.succeed(`type`)
    def getSequenceNumber: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.StartingPosition
  ) extends zio.aws.kinesis.model.StartingPosition.ReadOnly {
    override val `type`: zio.aws.kinesis.model.ShardIteratorType =
      zio.aws.kinesis.model.ShardIteratorType.wrap(impl.`type`())
    override val sequenceNumber: Optional[SequenceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceNumber())
        .map(value => zio.aws.kinesis.model.primitives.SequenceNumber(value))
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.StartingPosition
  ): zio.aws.kinesis.model.StartingPosition.ReadOnly = new Wrapper(impl)
}
