package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{KeyId, StreamName}
import scala.jdk.CollectionConverters._
final case class StopStreamEncryptionRequest(
    streamName: StreamName,
    encryptionType: zio.aws.kinesis.model.EncryptionType,
    keyId: KeyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest = {
    import StopStreamEncryptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .encryptionType(encryptionType.unwrap)
      .keyId(KeyId.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.StopStreamEncryptionRequest.ReadOnly =
    zio.aws.kinesis.model.StopStreamEncryptionRequest.wrap(buildAwsValue())
}
object StopStreamEncryptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.StopStreamEncryptionRequest =
      zio.aws.kinesis.model
        .StopStreamEncryptionRequest(streamName, encryptionType, keyId)
    def streamName: StreamName
    def encryptionType: zio.aws.kinesis.model.EncryptionType
    def keyId: KeyId
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.kinesis.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getKeyId: ZIO[Any, Nothing, KeyId] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest
  ) extends zio.aws.kinesis.model.StopStreamEncryptionRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val encryptionType: zio.aws.kinesis.model.EncryptionType =
      zio.aws.kinesis.model.EncryptionType.wrap(impl.encryptionType())
    override val keyId: KeyId =
      zio.aws.kinesis.model.primitives.KeyId(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest
  ): zio.aws.kinesis.model.StopStreamEncryptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
