package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StreamModeDetails(
    streamMode: zio.aws.kinesis.model.StreamMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.StreamModeDetails = {
    import StreamModeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.StreamModeDetails
      .builder()
      .streamMode(streamMode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.StreamModeDetails.ReadOnly =
    zio.aws.kinesis.model.StreamModeDetails.wrap(buildAwsValue())
}
object StreamModeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.StreamModeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.StreamModeDetails =
      zio.aws.kinesis.model.StreamModeDetails(streamMode)
    def streamMode: zio.aws.kinesis.model.StreamMode
    def getStreamMode: ZIO[Any, Nothing, zio.aws.kinesis.model.StreamMode] =
      ZIO.succeed(streamMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.StreamModeDetails
  ) extends zio.aws.kinesis.model.StreamModeDetails.ReadOnly {
    override val streamMode: zio.aws.kinesis.model.StreamMode =
      zio.aws.kinesis.model.StreamMode.wrap(impl.streamMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.StreamModeDetails
  ): zio.aws.kinesis.model.StreamModeDetails.ReadOnly = new Wrapper(impl)
}
