package zio.aws.kinesis.model
import scala.jdk.CollectionConverters._
sealed trait StreamStatus {
  def unwrap: software.amazon.awssdk.services.kinesis.model.StreamStatus
}
object StreamStatus {
  def wrap(
      value: software.amazon.awssdk.services.kinesis.model.StreamStatus
  ): zio.aws.kinesis.model.StreamStatus = value match {
    case software.amazon.awssdk.services.kinesis.model.StreamStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesis.model.StreamStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kinesis.model.StreamStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kinesis.model.StreamStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kinesis.model.StreamStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.kinesis.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamStatus =
      software.amazon.awssdk.services.kinesis.model.StreamStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kinesis.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamStatus =
      software.amazon.awssdk.services.kinesis.model.StreamStatus.CREATING
  }
  case object DELETING extends zio.aws.kinesis.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamStatus =
      software.amazon.awssdk.services.kinesis.model.StreamStatus.DELETING
  }
  case object ACTIVE extends zio.aws.kinesis.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamStatus =
      software.amazon.awssdk.services.kinesis.model.StreamStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.kinesis.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamStatus =
      software.amazon.awssdk.services.kinesis.model.StreamStatus.UPDATING
  }
}
