package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{MillisBehindLatest, SequenceNumber}
import scala.jdk.CollectionConverters._
final case class SubscribeToShardEvent(
    records: Iterable[zio.aws.kinesis.model.Record],
    continuationSequenceNumber: SequenceNumber,
    millisBehindLatest: MillisBehindLatest,
    childShards: Optional[Iterable[zio.aws.kinesis.model.ChildShard]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent = {
    import SubscribeToShardEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent
      .builder()
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .continuationSequenceNumber(
        SequenceNumber.unwrap(continuationSequenceNumber): java.lang.String
      )
      .millisBehindLatest(
        MillisBehindLatest.unwrap(millisBehindLatest): java.lang.Long
      )
      .optionallyWith(
        childShards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.childShards)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly =
    zio.aws.kinesis.model.SubscribeToShardEvent.wrap(buildAwsValue())
}
object SubscribeToShardEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.SubscribeToShardEvent =
      zio.aws.kinesis.model.SubscribeToShardEvent(
        records.map { item =>
          item.asEditable
        },
        continuationSequenceNumber,
        millisBehindLatest,
        childShards.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def records: List[zio.aws.kinesis.model.Record.ReadOnly]
    def continuationSequenceNumber: SequenceNumber
    def millisBehindLatest: MillisBehindLatest
    def childShards: Optional[List[zio.aws.kinesis.model.ChildShard.ReadOnly]]
    def getRecords
        : ZIO[Any, Nothing, List[zio.aws.kinesis.model.Record.ReadOnly]] =
      ZIO.succeed(records)
    def getContinuationSequenceNumber: ZIO[Any, Nothing, SequenceNumber] =
      ZIO.succeed(continuationSequenceNumber)
    def getMillisBehindLatest: ZIO[Any, Nothing, MillisBehindLatest] =
      ZIO.succeed(millisBehindLatest)
    def getChildShards
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.ChildShard.ReadOnly]] =
      AwsError.unwrapOptionField("childShards", childShards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent
  ) extends zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly {
    override val records: List[zio.aws.kinesis.model.Record.ReadOnly] = impl
      .records()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.Record.wrap(item)
      }
      .toList
    override val continuationSequenceNumber: SequenceNumber =
      zio.aws.kinesis.model.primitives
        .SequenceNumber(impl.continuationSequenceNumber())
    override val millisBehindLatest: MillisBehindLatest =
      zio.aws.kinesis.model.primitives
        .MillisBehindLatest(impl.millisBehindLatest())
    override val childShards
        : Optional[List[zio.aws.kinesis.model.ChildShard.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childShards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.ChildShard.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent
  ): zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly = new Wrapper(impl)
}
