package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.StreamARN
import scala.jdk.CollectionConverters._
final case class UpdateStreamModeRequest(
    streamARN: StreamARN,
    streamModeDetails: zio.aws.kinesis.model.StreamModeDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest = {
    import UpdateStreamModeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest
      .builder()
      .streamARN(StreamARN.unwrap(streamARN): java.lang.String)
      .streamModeDetails(streamModeDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.UpdateStreamModeRequest.ReadOnly =
    zio.aws.kinesis.model.UpdateStreamModeRequest.wrap(buildAwsValue())
}
object UpdateStreamModeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.UpdateStreamModeRequest =
      zio.aws.kinesis.model
        .UpdateStreamModeRequest(streamARN, streamModeDetails.asEditable)
    def streamARN: StreamARN
    def streamModeDetails: zio.aws.kinesis.model.StreamModeDetails.ReadOnly
    def getStreamARN: ZIO[Any, Nothing, StreamARN] = ZIO.succeed(streamARN)
    def getStreamModeDetails
        : ZIO[Any, Nothing, zio.aws.kinesis.model.StreamModeDetails.ReadOnly] =
      ZIO.succeed(streamModeDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest
  ) extends zio.aws.kinesis.model.UpdateStreamModeRequest.ReadOnly {
    override val streamARN: StreamARN =
      zio.aws.kinesis.model.primitives.StreamARN(impl.streamARN())
    override val streamModeDetails
        : zio.aws.kinesis.model.StreamModeDetails.ReadOnly =
      zio.aws.kinesis.model.StreamModeDetails.wrap(impl.streamModeDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest
  ): zio.aws.kinesis.model.UpdateStreamModeRequest.ReadOnly = new Wrapper(impl)
}
