package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait CustomKeyStoreType {
  def unwrap: software.amazon.awssdk.services.kms.model.CustomKeyStoreType
}
object CustomKeyStoreType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.CustomKeyStoreType
  ): zio.aws.kms.model.CustomKeyStoreType = value match {
    case software.amazon.awssdk.services.kms.model.CustomKeyStoreType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.CustomKeyStoreType.AWS_CLOUDHSM =>
      val r = AWS_CLOUDHSM
      r
    case software.amazon.awssdk.services.kms.model.CustomKeyStoreType.EXTERNAL_KEY_STORE =>
      val r = EXTERNAL_KEY_STORE
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.CustomKeyStoreType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomKeyStoreType =
      software.amazon.awssdk.services.kms.model.CustomKeyStoreType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_CLOUDHSM extends zio.aws.kms.model.CustomKeyStoreType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomKeyStoreType =
      software.amazon.awssdk.services.kms.model.CustomKeyStoreType.AWS_CLOUDHSM
  }
  case object EXTERNAL_KEY_STORE extends zio.aws.kms.model.CustomKeyStoreType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomKeyStoreType =
      software.amazon.awssdk.services.kms.model.CustomKeyStoreType.EXTERNAL_KEY_STORE
  }
}
