package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{CiphertextType, PlaintextType, KeyIdType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DecryptResponse(
    keyId: Optional[KeyIdType] = Optional.Absent,
    plaintext: Optional[PlaintextType] = Optional.Absent,
    encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      Optional.Absent,
    ciphertextForRecipient: Optional[CiphertextType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DecryptResponse = {
    import DecryptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DecryptResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        plaintext.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.plaintext)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .optionallyWith(
        ciphertextForRecipient.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.ciphertextForRecipient)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DecryptResponse.ReadOnly =
    zio.aws.kms.model.DecryptResponse.wrap(buildAwsValue())
}
object DecryptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DecryptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DecryptResponse =
      zio.aws.kms.model.DecryptResponse(
        keyId.map(value => value),
        plaintext.map(value => value),
        encryptionAlgorithm.map(value => value),
        ciphertextForRecipient.map(value => value)
      )
    def keyId: Optional[KeyIdType]
    def plaintext: Optional[PlaintextType]
    def encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def ciphertextForRecipient: Optional[CiphertextType]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getPlaintext: ZIO[Any, AwsError, PlaintextType] =
      AwsError.unwrapOptionField("plaintext", plaintext)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
    def getCiphertextForRecipient: ZIO[Any, AwsError, CiphertextType] = AwsError
      .unwrapOptionField("ciphertextForRecipient", ciphertextForRecipient)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DecryptResponse
  ) extends zio.aws.kms.model.DecryptResponse.ReadOnly {
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val plaintext: Optional[PlaintextType] = zio.aws.core.internal
      .optionalFromNullable(impl.plaintext())
      .map(value =>
        zio.aws.kms.model.primitives
          .PlaintextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val encryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
    override val ciphertextForRecipient: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ciphertextForRecipient())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DecryptResponse
  ): zio.aws.kms.model.DecryptResponse.ReadOnly = new Wrapper(impl)
}
