package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCustomKeyStoresResponse(
    customKeyStores: Optional[
      Iterable[zio.aws.kms.model.CustomKeyStoresListEntry]
    ] = Optional.Absent,
    nextMarker: Optional[MarkerType] = Optional.Absent,
    truncated: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse = {
    import DescribeCustomKeyStoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse
      .builder()
      .optionallyWith(
        customKeyStores.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customKeyStores)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly =
    zio.aws.kms.model.DescribeCustomKeyStoresResponse.wrap(buildAwsValue())
}
object DescribeCustomKeyStoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DescribeCustomKeyStoresResponse =
      zio.aws.kms.model.DescribeCustomKeyStoresResponse(
        customKeyStores.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def customKeyStores
        : Optional[List[zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly]]
    def nextMarker: Optional[MarkerType]
    def truncated: Optional[BooleanType]
    def getCustomKeyStores: ZIO[Any, AwsError, List[
      zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("customKeyStores", customKeyStores)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse
  ) extends zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly {
    override val customKeyStores
        : Optional[List[zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customKeyStores())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.CustomKeyStoresListEntry.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse
  ): zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly = new Wrapper(
    impl
  )
}
