package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{CiphertextType, PlaintextType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateRandomResponse(
    plaintext: Optional[PlaintextType] = Optional.Absent,
    ciphertextForRecipient: Optional[CiphertextType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateRandomResponse = {
    import GenerateRandomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateRandomResponse
      .builder()
      .optionallyWith(
        plaintext.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.plaintext)
      .optionallyWith(
        ciphertextForRecipient.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.ciphertextForRecipient)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateRandomResponse.ReadOnly =
    zio.aws.kms.model.GenerateRandomResponse.wrap(buildAwsValue())
}
object GenerateRandomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateRandomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateRandomResponse =
      zio.aws.kms.model.GenerateRandomResponse(
        plaintext.map(value => value),
        ciphertextForRecipient.map(value => value)
      )
    def plaintext: Optional[PlaintextType]
    def ciphertextForRecipient: Optional[CiphertextType]
    def getPlaintext: ZIO[Any, AwsError, PlaintextType] =
      AwsError.unwrapOptionField("plaintext", plaintext)
    def getCiphertextForRecipient: ZIO[Any, AwsError, CiphertextType] = AwsError
      .unwrapOptionField("ciphertextForRecipient", ciphertextForRecipient)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateRandomResponse
  ) extends zio.aws.kms.model.GenerateRandomResponse.ReadOnly {
    override val plaintext: Optional[PlaintextType] = zio.aws.core.internal
      .optionalFromNullable(impl.plaintext())
      .map(value =>
        zio.aws.kms.model.primitives
          .PlaintextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val ciphertextForRecipient: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ciphertextForRecipient())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateRandomResponse
  ): zio.aws.kms.model.GenerateRandomResponse.ReadOnly = new Wrapper(impl)
}
