package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters._
final case class GetKeyRotationStatusRequest(keyId: KeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest = {
    import GetKeyRotationStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetKeyRotationStatusRequest.ReadOnly =
    zio.aws.kms.model.GetKeyRotationStatusRequest.wrap(buildAwsValue())
}
object GetKeyRotationStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetKeyRotationStatusRequest =
      zio.aws.kms.model.GetKeyRotationStatusRequest(keyId)
    def keyId: KeyIdType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest
  ) extends zio.aws.kms.model.GetKeyRotationStatusRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest
  ): zio.aws.kms.model.GetKeyRotationStatusRequest.ReadOnly = new Wrapper(impl)
}
