package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait KeyEncryptionMechanism {
  def unwrap: software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism
}
object KeyEncryptionMechanism {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism
  ): zio.aws.kms.model.KeyEncryptionMechanism = value match {
    case software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism.RSAES_OAEP_SHA_256 =>
      val r = RSAES_OAEP_SHA_256
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.KeyEncryptionMechanism {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism =
      software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism.UNKNOWN_TO_SDK_VERSION
  }
  case object RSAES_OAEP_SHA_256
      extends zio.aws.kms.model.KeyEncryptionMechanism {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism =
      software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism.RSAES_OAEP_SHA_256
  }
}
