package zio.aws.kms.model
import zio.prelude.data.Optional
import zio.aws.kms.model.primitives.{MarkerType, LimitType, KeyIdType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKeyPoliciesRequest(
    keyId: KeyIdType,
    limit: Optional[LimitType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest = {
    import ListKeyPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListKeyPoliciesRequest.ReadOnly =
    zio.aws.kms.model.ListKeyPoliciesRequest.wrap(buildAwsValue())
}
object ListKeyPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListKeyPoliciesRequest =
      zio.aws.kms.model.ListKeyPoliciesRequest(
        keyId,
        limit.map(value => value),
        marker.map(value => value)
      )
    def keyId: KeyIdType
    def limit: Optional[LimitType]
    def marker: Optional[MarkerType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest
  ) extends zio.aws.kms.model.ListKeyPoliciesRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.kms.model.primitives.LimitType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest
  ): zio.aws.kms.model.ListKeyPoliciesRequest.ReadOnly = new Wrapper(impl)
}
