package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListResourceTagsResponse(
    tags: Optional[Iterable[zio.aws.kms.model.Tag]] = Optional.Absent,
    nextMarker: Optional[MarkerType] = Optional.Absent,
    truncated: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListResourceTagsResponse = {
    import ListResourceTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListResourceTagsResponse.ReadOnly =
    zio.aws.kms.model.ListResourceTagsResponse.wrap(buildAwsValue())
}
object ListResourceTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListResourceTagsResponse =
      zio.aws.kms.model.ListResourceTagsResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def tags: Optional[List[zio.aws.kms.model.Tag.ReadOnly]]
    def nextMarker: Optional[MarkerType]
    def truncated: Optional[BooleanType]
    def getTags: ZIO[Any, AwsError, List[zio.aws.kms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
  ) extends zio.aws.kms.model.ListResourceTagsResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.kms.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.Tag.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
  ): zio.aws.kms.model.ListResourceTagsResponse.ReadOnly = new Wrapper(impl)
}
