package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  BooleanType,
  PolicyType,
  PolicyNameType,
  KeyIdType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutKeyPolicyRequest(
    keyId: KeyIdType,
    policyName: PolicyNameType,
    policy: PolicyType,
    bypassPolicyLockoutSafetyCheck: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest = {
    import PutKeyPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .policy(PolicyType.unwrap(policy): java.lang.String)
      .optionallyWith(
        bypassPolicyLockoutSafetyCheck.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.bypassPolicyLockoutSafetyCheck)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.PutKeyPolicyRequest.ReadOnly =
    zio.aws.kms.model.PutKeyPolicyRequest.wrap(buildAwsValue())
}
object PutKeyPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.PutKeyPolicyRequest =
      zio.aws.kms.model.PutKeyPolicyRequest(
        keyId,
        policyName,
        policy,
        bypassPolicyLockoutSafetyCheck.map(value => value)
      )
    def keyId: KeyIdType
    def policyName: PolicyNameType
    def policy: PolicyType
    def bypassPolicyLockoutSafetyCheck: Optional[BooleanType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
    def getPolicy: ZIO[Any, Nothing, PolicyType] = ZIO.succeed(policy)
    def getBypassPolicyLockoutSafetyCheck: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "bypassPolicyLockoutSafetyCheck",
        bypassPolicyLockoutSafetyCheck
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest
  ) extends zio.aws.kms.model.PutKeyPolicyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val policyName: PolicyNameType =
      zio.aws.kms.model.primitives.PolicyNameType(impl.policyName())
    override val policy: PolicyType =
      zio.aws.kms.model.primitives.PolicyType(impl.policy())
    override val bypassPolicyLockoutSafetyCheck: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bypassPolicyLockoutSafetyCheck())
        .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest
  ): zio.aws.kms.model.PutKeyPolicyRequest.ReadOnly = new Wrapper(impl)
}
