package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.AttestationDocumentType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecipientInfo(
    keyEncryptionAlgorithm: Optional[zio.aws.kms.model.KeyEncryptionMechanism] =
      Optional.Absent,
    attestationDocument: Optional[AttestationDocumentType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.RecipientInfo = {
    import RecipientInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.RecipientInfo
      .builder()
      .optionallyWith(keyEncryptionAlgorithm.map(value => value.unwrap))(
        _.keyEncryptionAlgorithm
      )
      .optionallyWith(
        attestationDocument.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.attestationDocument)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.RecipientInfo.ReadOnly =
    zio.aws.kms.model.RecipientInfo.wrap(buildAwsValue())
}
object RecipientInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.RecipientInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.RecipientInfo =
      zio.aws.kms.model.RecipientInfo(
        keyEncryptionAlgorithm.map(value => value),
        attestationDocument.map(value => value)
      )
    def keyEncryptionAlgorithm
        : Optional[zio.aws.kms.model.KeyEncryptionMechanism]
    def attestationDocument: Optional[AttestationDocumentType]
    def getKeyEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.KeyEncryptionMechanism] =
      AwsError.unwrapOptionField(
        "keyEncryptionAlgorithm",
        keyEncryptionAlgorithm
      )
    def getAttestationDocument: ZIO[Any, AwsError, AttestationDocumentType] =
      AwsError.unwrapOptionField("attestationDocument", attestationDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.RecipientInfo
  ) extends zio.aws.kms.model.RecipientInfo.ReadOnly {
    override val keyEncryptionAlgorithm
        : Optional[zio.aws.kms.model.KeyEncryptionMechanism] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyEncryptionAlgorithm())
        .map(value => zio.aws.kms.model.KeyEncryptionMechanism.wrap(value))
    override val attestationDocument: Optional[AttestationDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attestationDocument())
        .map(value =>
          zio.aws.kms.model.primitives.AttestationDocumentType(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.RecipientInfo
  ): zio.aws.kms.model.RecipientInfo.ReadOnly = new Wrapper(impl)
}
