package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  KeyIdType,
  BooleanType,
  RegionType,
  DescriptionType,
  PolicyType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicateKeyRequest(
    keyId: KeyIdType,
    replicaRegion: RegionType,
    policy: Optional[PolicyType] = Optional.Absent,
    bypassPolicyLockoutSafetyCheck: Optional[BooleanType] = Optional.Absent,
    description: Optional[DescriptionType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.kms.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ReplicateKeyRequest = {
    import ReplicateKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .replicaRegion(RegionType.unwrap(replicaRegion): java.lang.String)
      .optionallyWith(
        policy.map(value => PolicyType.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(
        bypassPolicyLockoutSafetyCheck.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.bypassPolicyLockoutSafetyCheck)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ReplicateKeyRequest.ReadOnly =
    zio.aws.kms.model.ReplicateKeyRequest.wrap(buildAwsValue())
}
object ReplicateKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ReplicateKeyRequest =
      zio.aws.kms.model.ReplicateKeyRequest(
        keyId,
        replicaRegion,
        policy.map(value => value),
        bypassPolicyLockoutSafetyCheck.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyId: KeyIdType
    def replicaRegion: RegionType
    def policy: Optional[PolicyType]
    def bypassPolicyLockoutSafetyCheck: Optional[BooleanType]
    def description: Optional[DescriptionType]
    def tags: Optional[List[zio.aws.kms.model.Tag.ReadOnly]]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getReplicaRegion: ZIO[Any, Nothing, RegionType] =
      ZIO.succeed(replicaRegion)
    def getPolicy: ZIO[Any, AwsError, PolicyType] =
      AwsError.unwrapOptionField("policy", policy)
    def getBypassPolicyLockoutSafetyCheck: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "bypassPolicyLockoutSafetyCheck",
        bypassPolicyLockoutSafetyCheck
      )
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
  ) extends zio.aws.kms.model.ReplicateKeyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val replicaRegion: RegionType =
      zio.aws.kms.model.primitives.RegionType(impl.replicaRegion())
    override val policy: Optional[PolicyType] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.kms.model.primitives.PolicyType(value))
    override val bypassPolicyLockoutSafetyCheck: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bypassPolicyLockoutSafetyCheck())
        .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val description: Optional[DescriptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kms.model.primitives.DescriptionType(value))
    override val tags: Optional[List[zio.aws.kms.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ReplicateKeyRequest
  ): zio.aws.kms.model.ReplicateKeyRequest.ReadOnly = new Wrapper(impl)
}
