package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{TagKeyType, KeyIdType}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    keyId: KeyIdType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.UntagResourceRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.UntagResourceRequest.ReadOnly =
    zio.aws.kms.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.UntagResourceRequest =
      zio.aws.kms.model.UntagResourceRequest(keyId, tagKeys)
    def keyId: KeyIdType
    def tagKeys: List[TagKeyType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.UntagResourceRequest
  ) extends zio.aws.kms.model.UntagResourceRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.kms.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.UntagResourceRequest
  ): zio.aws.kms.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
