package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  CiphertextType,
  KeyIdType,
  PlaintextType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifyMacRequest(
    message: PlaintextType,
    keyId: KeyIdType,
    macAlgorithm: zio.aws.kms.model.MacAlgorithmSpec,
    mac: CiphertextType,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.VerifyMacRequest = {
    import VerifyMacRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.VerifyMacRequest
      .builder()
      .message(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          message.toArray[Byte]
        )
      )
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .macAlgorithm(macAlgorithm.unwrap)
      .mac(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(mac.toArray[Byte])
      )
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.VerifyMacRequest.ReadOnly =
    zio.aws.kms.model.VerifyMacRequest.wrap(buildAwsValue())
}
object VerifyMacRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.VerifyMacRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.VerifyMacRequest =
      zio.aws.kms.model.VerifyMacRequest(
        message,
        keyId,
        macAlgorithm,
        mac,
        grantTokens.map(value => value)
      )
    def message: PlaintextType
    def keyId: KeyIdType
    def macAlgorithm: zio.aws.kms.model.MacAlgorithmSpec
    def mac: CiphertextType
    def grantTokens: Optional[List[GrantTokenType]]
    def getMessage: ZIO[Any, Nothing, PlaintextType] = ZIO.succeed(message)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getMacAlgorithm: ZIO[Any, Nothing, zio.aws.kms.model.MacAlgorithmSpec] =
      ZIO.succeed(macAlgorithm)
    def getMac: ZIO[Any, Nothing, CiphertextType] = ZIO.succeed(mac)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.VerifyMacRequest
  ) extends zio.aws.kms.model.VerifyMacRequest.ReadOnly {
    override val message: PlaintextType = zio.aws.kms.model.primitives
      .PlaintextType(zio.Chunk.fromArray(impl.message().asByteArrayUnsafe()))
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val macAlgorithm: zio.aws.kms.model.MacAlgorithmSpec =
      zio.aws.kms.model.MacAlgorithmSpec.wrap(impl.macAlgorithm())
    override val mac: CiphertextType = zio.aws.kms.model.primitives
      .CiphertextType(zio.Chunk.fromArray(impl.mac().asByteArrayUnsafe()))
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.VerifyMacRequest
  ): zio.aws.kms.model.VerifyMacRequest.ReadOnly = new Wrapper(impl)
}
